/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: CmdTable_Functionlist.h 5746 2016-05-12 16:01:16Z ynikolov $:

Description:
 The header has to be included in the configuration source file of firmware.
  Use the content of header file to configure the startup parameter of tasks

Changes:

 -----------------------------------------------------------------------------------
 2016-01-13 created
**************************************************************************************/


#ifndef __CMDTBL_FUNCTIONLIST_H
#define __CMDTBL_FUNCTIONLIST_H

#include "rcX_User.h"

#ifndef TLR_TASK_COMMAND_TABLE
#define TLR_TASK_COMMAND_TABLE (0x00E20000L)
#endif


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
CmdTbl_TaskExit
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
CmdTbl_TaskLeave
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
CmdTbl_TaskEnter
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define CMDTBL_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct CMDTBL_STARTUPPARAMETER_Ttag  CMDTBL_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */

#define CMDTBL_DEFAULT_PRM_MAX_READ_IMG_SIZE          (5680)
#define CMDTBL_DEFAULT_PRM_MAX_WRITE_IMG_SIZE         NETX_IO_DATA_SIZE
#define CMDTBL_DEFAULT_PRM_WRITE_IMG_OFFSET           NETX_IO_DATA_SIZE
#define CMDTBL_DEFAULT_PRM_OMB_OMBTASK_QUEUE_NAME     "QUE_OMBTASK"
#define CMDTBL_DEFAULT_PRM_OMB_QUEUE_INSTANCE         (0)
#define CMDTBL_DEFAULT_PRM_MAX_COMMAND_NUMBER         (256)

struct CMDTBL_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  uint32_t      ulMaxReadImageSize;
  uint32_t      ulMaxWriteImageSize;
  uint32_t      ulWriteImageOffset;
  uint8_t       abDestQueueName[16];
  uint32_t      ulDestQueueInst;
  uint32_t      ulMaxCommandsNumber;
};

/******************************************************************
 * Comamnd Table Default Start-Up Parameters
 ******************************************************************
 ******************************************************************
  STATIC CONST CMDTBL_STARTUPPARAMETER_T s_tCmdTblTaskParam =
  {
    TLR_TASK_COMMAND_TABLE,
    CMDTBL_STARTUP_PARAM_VERSION,
    CMDTBL_DEFAULT_PRM_MAX_READ_IMG_SIZE,
    CMDTBL_DEFAULT_PRM_MAX_WRITE_IMG_SIZE,
    CMDTBL_DEFAULT_PRM_WRITE_IMG_OFFSET,
    CMDTBL_DEFAULT_PRM_OMB_OMBTASK_QUEUE_NAME,
    CMDTBL_DEFAULT_PRM_OMB_QUEUE_INSTANCE,
    CMDTBL_DEFAULT_PRM_MAX_COMMAND_NUMBER
  };
 ******************************************************************
 ******************************************************************
 */


/*************************************************************************************/
#endif /* #ifndef __CMDTBL_FUNCTIONLIST_H */
